﻿<# 
.SYNOPSIS 
    Das Script fügt einen neuen Client zum DHCP-Filter hinzu, legt wenn erwünscht eine 
    DHCP-Reservierung an und legt den Client im SCCM an. Darüber hinaus ist es möglich 
    den Client direkt einer Sammlung hinzuzufügen.
    In der aktuellen Version werden keine Fehler abgefangen!!!
.DESCRIPTION 
    Über die vier Eingabefelder werden, MAC-Adresse, Computername, IP-Adresse und die 
    Zielsammlung erfragt. Computername und MAC-Adresse sind erforderlich. Ohne diese 
    Eingaben ist keine Verarbeitung möglich.
    Die Felder IP-Adresse und Sammlung sind Optional!
    Der Aufruf erfolt lediglich durch Start des Skripts ohne Parameter. 
    Daraufhin startet die GUI.
.NOTES 
    Autor: Eric Berg
    Mail: info@ericberg.de
    Web: http://www.ericberg.de 
    Version: 0.2
#>

#########################
# set DHCP allow filter # 
#########################

Function DHCPFilterAdd {
    
    $MAC = $objMACBox.Text -replace("[-]","")   
    netsh dhcp server \\dhcpserver v4 add filter allow $MAC $objNameBox.Text
    
    DHCPReservationAdd
}

########################
# set DHCP reservation # 
########################

Function DHCPReservationAdd {
    
    $MAC2 = $objMACBox.Text -replace("[-]","")
    netsh dhcp server \\dhcpserver scope 10.0.0.0 add reservedip $objIPBox.Text $MAC2 $objNameBox.Text $objNameBox.Text "BOTH"
    
    Import-ConfigMgr
}

##############################
# import Client to SCCM #
##############################

Function Import-ConfigMgr
{
 ### Define variables to import the client to ConfigMgr
 $ResourceName = $objNameBox.Text
 $MACAddress = $objMACBox.Text -replace("[-]",":")

 ### Which collection should the client be imported to?
 $CollectionName = $objListbox.Text

    #Collection query
    $CollectionQuery = Get-WmiObject -Namespace "Root\SMS\Site_PRI" -Class SMS_Collection -Filter "Name='$CollectionName'"
 
    #New computer account information
    $WMIConnection = ([WMIClass]"\\sccmserver\root\SMS\Site_PRI:PRI_Site")
        $NewEntry = $WMIConnection.psbase.GetMethodParameters("ImportMachineEntry")
        $NewEntry.MACAddress = $MACAddress
        $NewEntry.NetbiosName = $ResourceName
        $NewEntry.OverwriteExistingRecord = $True
    $Resource = $WMIConnection.psbase.InvokeMethod("ImportMachineEntry",$NewEntry,$null)
 
    #Create the Direct MemberShip Rule
    $NewRule = ([WMIClass]"\\sccmserver\root\SMS\Site_PRI:SMS_CollectionRuleDirect").CreateInstance()
    $NewRule.ResourceClassName = "SMS_R_SYSTEM"
    $NewRule.ResourceID = $Resource.ResourceID
    $NewRule.Rulename = $ResourceName
 
    #Add the newly created machine to collection
    $CollectionQuery.AddMemberShipRule($NewRule)
    
    end
}

####################
# Abschlussmeldung #
####################

function end {
    $wshell = New-Object -ComObject Wscript.Shell

    $wshell.Popup("Vorgang abgeschlossen",0,"Import erfolgreich",64)
}

##################
# Formularaufruf #
##################

[void] [System.Reflection.Assembly]::LoadWithPartialName(“System.Drawing”)
[void] [System.Reflection.Assembly]::LoadWithPartialName(“System.Windows.Forms”)
$objForm = New-Object System.Windows.Forms.Form
$objForm.Text = “Neuen PC importieren”
$objForm.Size = New-Object System.Drawing.Size(400,400)
$objForm.StartPosition = “CenterScreen”
$objForm.KeyPreview = $True
$objForm.Add_KeyDown({if ($_.KeyCode -eq “Enter”) { $objForm.DialogResult=”OK”;$objForm.Close()}
     {
         foreach ($objItem in $objListbox.SelectedItems)
             {$x += $objItem}
         $objForm.Close()
     }
})
$objForm.Add_KeyDown({if ($_.KeyCode -eq “Escape”) { $objForm.DialogResult=”Cancel”;$objForm.Close()} })

$OKButton = New-Object System.Windows.Forms.Button
$OKButton.Location = New-Object System.Drawing.Size(75,350)
$OKButton.Size = New-Object System.Drawing.Size(75,23)
$OKButton.Text = “OK”
$OKButton.DialogResult = “OK”
$OKButton.Add_Click(
    {
         foreach ($objItem in $objListbox.SelectedItems)
             {$x += $objItem}
         $objForm.Close()
    }
)
$objForm.Controls.Add($OKButton)

$CancelButton = New-Object System.Windows.Forms.Button
$CancelButton.Location = New-Object System.Drawing.Size(200,350)
$CancelButton.Size = New-Object System.Drawing.Size(75,23)
$CancelButton.Text = “Abbrechen”
$CancelButton.DialogResult = “Cancel”
$CancelButton.Add_Click({$objForm.Close()})
$objForm.Controls.Add($CancelButton)

$objLabel = New-Object System.Windows.Forms.Label
$objLabel.Location = New-Object System.Drawing.Size(10,20)
$objLabel.Size = New-Object System.Drawing.Size(350,20)
$objLabel.Text = “Bitte MAC-Adresse im Format 00-11-22-33-44-55 eingeben:”
$objForm.Controls.Add($objLabel)
$objMACBox = New-Object System.Windows.Forms.TextBox
$objMACBox.Location = New-Object System.Drawing.Size(10,40)
$objMACBox.Size = New-Object System.Drawing.Size(350,20)
$objMACBox.Text = “MAC-Adresse”
$objForm.Controls.Add($objMACBox)

$objLabel = New-Object System.Windows.Forms.Label
$objLabel.Location = New-Object System.Drawing.Size(10,80)
$objLabel.Size = New-Object System.Drawing.Size(350,20)
$objLabel.Text = “Bitte Computernamen eingeben:”
$objForm.Controls.Add($objLabel)
$objNameBox = New-Object System.Windows.Forms.TextBox
$objNameBox.Location = New-Object System.Drawing.Size(10,100)
$objNameBox.Size = New-Object System.Drawing.Size(350,20)
$objNameBox.Text = “Computername”
$objForm.Controls.Add($objNameBox)

$objLabel = New-Object System.Windows.Forms.Label
$objLabel.Location = New-Object System.Drawing.Size(10,140)
$objLabel.Size = New-Object System.Drawing.Size(350,20)
$objLabel.Text = “Bitte IP-Adresse eingeben:”
$objForm.Controls.Add($objLabel)
$objIPBox = New-Object System.Windows.Forms.TextBox
$objIPBox.Location = New-Object System.Drawing.Size(10,160)
$objIPBox.Size = New-Object System.Drawing.Size(350,20)
$objIPBox.Text = “IP-Adresse”
$objForm.Controls.Add($objIPBox)

$objLabel = New-Object System.Windows.Forms.Label
$objLabel.Location = New-Object System.Drawing.Size(10,200) 
$objLabel.Size = New-Object System.Drawing.Size(350,20) 
$objLabel.Text = "Wählen Sie eine Sammlung aus"
$objForm.Controls.Add($objLabel) 

$objListbox = New-Object System.Windows.Forms.Listbox 
$objListbox.Location = New-Object System.Drawing.Size(10,220) 
$objListbox.Size = New-Object System.Drawing.Size(350,20) 
$objListbox.SelectionMode = "MultiExtended"

[void] $objListbox.Items.Add("Deploy Windows 7 Pro x64")
[void] $objListbox.Items.Add("Deploy Windows 8 Ent x64")
[void] $objListbox.Items.Add("not defined")
[void] $objListbox.Items.Add("not defined")
[void] $objListbox.Items.Add("not defined")

$objListbox.Height = 70
$objForm.Controls.Add($objListbox) 

[void] $objForm.ShowDialog()

If ($objForm.DialogResult -like “OK”)
    {DHCPFilterAdd}
    else 
        {“Abbruch geklickt”}